<?php
// ======================================================
// CONTEXT & ROLE
// ======================================================
$context = $ctx ?? 'dashboard';
$role    = (string) (user()->is_superadmin ?? '0');

// ======================================================
// WARNA SIDEBAR BERDASARKAN CONTEXT
// ======================================================
$contextColors = [
    'dashboard'        => 'purple',
    'qrcode'           => 'purple',
    'menupiket'        => 'green',
    'menupersentasi'   => 'green',
    'menurekap'        => 'green',
    'siswa'            => 'danger',
    'petugas'          => 'dark',
    'menupengaturan'   => 'orange',
    'absenotomatis'    => 'orange',
    'jam-presensi'     => 'azure',
    'pelanggaransiswa' => 'azure',
];

$sidebarColor = $contextColors[$context] ?? 'rose';

// ======================================================
// DAFTAR MENU (SATU PUSAT)
// ======================================================
$menus = [

    [
        'label' => 'Dashboard',
        'icon'  => 'home',
        // 'url'   => 'admin/dashboard',
        'url'   => 'admin/menu',
        'ctx'   => 'dashboard',
        // 'roles' => ['0','1','2','3','4','5','6']
        'roles' => ['0','1']
    ],

    [
        'label' => 'Absensi Siswa',
        'icon'  => 'qr_code_scanner',
        'url'   => 'admin/qrcodeall',
        'ctx'   => 'qrcode',
        'roles' => ['1','2','3']
    ],

    [
        'label' => 'Piket Harian',
        'icon'  => 'article',
        'url'   => 'admin/menupiket',
        'ctx'   => 'menupiket',
        'roles' => ['1','2','3']
    ],

    [
        'label' => 'Persentasi Kehadiran',
        'icon'  => 'pie_chart',
        'url'   => 'admin/menu-persentasi',
        'ctx'   => 'menupersentasi',
        'roles' => ['1','2','3']
    ],

    [
        'label' => 'Laporan Kehadiran',
        'icon'  => 'print',
        'url'   => 'admin/menurekap',
        'ctx'   => 'menurekap',
        'roles' => ['1','2','3']
    ],

    [
        'label' => 'Data Siswa',
        'icon'  => 'person',
        'url'   => 'admin/siswa',
        'ctx'   => 'siswa',
        'roles' => ['1','2']
    ],

    [
        'label' => 'Generate QR Code',
        'icon'  => 'qr_code',
        'url'   => 'admin/generate',
        'ctx'   => 'qr',
        'roles' => ['1','2']
    ],

    [
        'label' => 'Data Petugas',
        'icon'  => 'computer',
        'url'   => 'admin/petugas',
        'ctx'   => 'petugas',
        'roles' => ['1']
    ],

    [
        'label' => 'Absensi System',
        'icon'  => 'settings',
        'url'   => 'admin/absenotomatis',
        'ctx'   => 'absenotomatis',
        'roles' => ['1']
    ],

    [
        'label' => 'Setting',
        'icon'  => 'settings',
        'url'   => 'admin/menuseting',
        'ctx'   => 'menupengaturan',
        'roles' => ['1','2']
    ],
];
?>

<!-- ====================================================== -->
<!-- SIDEBAR -->
<!-- ====================================================== -->
<div class="sidebar"
     data-color="<?= $sidebarColor ?>"
     data-background-color="black"
     data-image="<?= base_url('assets/img/sidebar/sidebar-1.jpg'); ?>">

    <div class="logo">
        <a class="simple-text logo-normal">
            <b>SMAN 1 Cikatomas <br>2026</b>
        </a>
    </div>

    <div class="sidebar-wrapper">
        <ul class="nav">

        <?php foreach ($menus as $m): ?>
            <?php if (in_array($role, $m['roles'], true)): ?>
                <li class="nav-item <?= $context === $m['ctx'] ? 'active' : '' ?>">
                    <a class="nav-link" href="<?= base_url($m['url']) ?>">
                        <i class="material-icons"><?= $m['icon'] ?></i>
                        <p><?= $m['label'] ?></p>
                    </a>
                </li>
            <?php endif; ?>
        <?php endforeach; ?>

        </ul>
    </div>
</div>
